﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class HoppingBattleMainUI : BattleMainUI//,IHoppingBattleListener
{
    HoppingBattleController hoppingBattleController  => this.battleController as HoppingBattleController;
    
    public RectTransform finger;
    public NumShow scoreText;

    public GameObject debugObj;
    public Text switchDropDownText;

    public GameObject[] UIs;

    public BattleJoinPad touchPad;
    
    public override void Awake()
    {
        base.Awake();
        
        touchPad.onMove = OnPointerMove;
        touchPad.onPointerDown = OnPointerDown;
        touchPad.onPointerUp = OnPointerUp;
        
#if DEBUG
        debugObj.SetActive(true);
        #else
        debugObj.SetActive(false);
        #endif

        scoreText.num = 0;
    }

    public override void Init(BattleController mController)
    {
        base.Init(mController);

        //hoppingBattleController.battleListener = this;

        if(s_HideUI)
            this.HideUI();
    }

    public override void Start()
    {
        base.Start();
        
        if(m_InCamStartMove)
            this.touchPad.gameObject.SetActive(false);
    }

    private void OnPointerDown(Vector3 position)
    {
        hoppingBattleController.OnPointerDown(position);
    }

    private void OnPointerMove(Vector2 dir)
    {
        if(!hoppingBattleController.GameStarted)
            this.OnClickStart();

        hoppingBattleController.OnPointerMove(dir);
    }
    
    private void OnPointerUp(Vector3 position)
    {
        hoppingBattleController.OnPointerUp(position);
    }
    
    void ShowUI()
    {
        foreach (GameObject uI in UIs)
        {
            uI.SetActive(true);
        }
    }
    void HideUI()
    {
        foreach (GameObject uI in UIs)
        {
            uI.SetActive(false);
        }
        
    }
    
    TransformAnim m_TransformAnim;
    TransformAnim transformAnim
    {
        get
        {
            if (m_TransformAnim == null) m_TransformAnim = gameObject.AddComponent<TransformAnim>();
            return m_TransformAnim;
        }
    }

    
    Vector3 m_LastTouchPos;
    static bool  s_ShowDebug;
    bool moveRD;
    bool moveLD;
    bool moveLU;
    bool moveRU;
    public static bool s_HideUI;
    /// <summary>
    /// 延迟隐藏手指
    /// </summary>
    private int FingerFrameCount;

    void Update()
    {
        if (!m_InCamStartMove && !touchPad.gameObject.activeSelf)
        {
            touchPad.gameObject.SetActive(true);
        }
        
        if (Input.GetMouseButton(0))
        {
            if (finger && s_HideUI)
            {
                if (!finger.gameObject.activeSelf)
                {
                    FingerFrameCount = 0;
                    finger.gameObject.SetActive(true);
                }

                finger.SetUIPosition(this.uiCamera.ScreenToWorldPoint(Input.mousePosition));
                //finger.rectTransform.SetUIPosition(pos);
            }
        }
        else
        {
            if (finger && finger.gameObject.activeSelf)
            {
                FingerFrameCount++;
                if (FingerFrameCount >= 5 || !s_HideUI)
                    finger.gameObject.SetActive(false);
            }
        }
 //转圈显示测试按钮
        
        bool touchingCheck = false;
        Vector3 dir = Vector3.zero;

#if UNITY_EDITOR
        touchingCheck = Input.GetMouseButton(0) && Input.mousePosition.y > (float)Screen.height * 1 / 2;
 
        dir = Input.mousePosition - m_LastTouchPos;
        m_LastTouchPos = Input.mousePosition;
#else
        if (Input.touchCount > 0)
        {
            var mousePos = Input.GetTouch(0).position;
            touchingCheck = Input.touchCount > 0 && mousePos.y > (float)Screen.height * 1 / 2;

            dir = mousePos - new Vector2(m_LastTouchPos.x, m_LastTouchPos.y);
            m_LastTouchPos = Input.GetTouch(0).position;
        }
#endif

        if (touchingCheck)
        {
            if (dir.x > 0 && dir.y < 0)
            {
                if (!moveRD)
                {
                    moveRD = true;
                }
            }

            if (moveRD)
            {
                if (dir.x < 0 && dir.y < 0)
                {
                    moveLD = true;
                }
            }
            if (moveLD)
            {
                if (dir.x < 0 && dir.y > 0)
                {
                    moveLU = true;
                }
            }
            if (moveLU)
            {
                if (dir.x > 0 && dir.y > 0)
                {
                    if (!moveRU)
                    {
                        moveRU = true;

                        bool switchHideUI = true;

                        /*if (Application.platform == RuntimePlatform.WindowsEditor ||
                            Application.platform == RuntimePlatform.OSXEditor)
                        {
                            switchHideUI = !Input.GetMouseButton(0);
                        }
                        else
                        {
                            switchHideUI = Input.touchCount == 1;
                        }*/
                        
                        if (switchHideUI)
                        {
                            s_HideUI = !s_HideUI;
                            if(s_HideUI)
                                this.HideUI();
                            else 
                                ShowUI();
                            GameDebug.LogError($"switchHideUI:{s_HideUI}");
                        }
                    }
                }
            }
            
        }
        else
        {
            moveRD = moveLD = moveLU = moveRU = false;
        }

    }

}
