﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public enum MotionType
{
    None = 0,
    Idle = 1,
    Run = 2,
    Hurt  = 3,
    Attack = 4,
    Dizzy  = 5,
}

public partial class RoleMotion : MonoBehaviour {
    
    RoleController rc => transform.GetComponentInParent<RoleController>();
        
    Animator m_Animator;
    public Animator animator
    {
        get
        {
            if(m_Animator == null)
            {
                if (rc)
                    m_Animator = rc.Animator;
            }
            if(m_Animator == null)
                m_Animator =  GetComponentInChildren<Animator>();
            
            return m_Animator;
        }
    }
    
    /// <summary>
    /// 角色默认速度乘数
    /// </summary>
    //public float defaultRunSpeedFactor = 1;

    /// <summary>
    /// 角色速度乘数
    /// </summary>
    public float runSpeedFactor { get; set; }

    //动作改变,上一个动作Exit
    public Action<string> onAnimChangeExit;

/*    GameObject Model
    {
        get
        {
            if (rc != null)
                return rc.moveRoot;
            else
                return gameObject;
        }
    }*/

    /// <summary>
    /// 当前动作状态
    /// </summary>
    MotionType curState
    {
        get
        {
            return m_PreState;
        }
        set
        {
            if(m_PreState != value)
            {
                if(onAnimChangeExit != null)
                {
                    onAnimChangeExit(m_PreState.ToString());
                }
                m_PreState = value;
            }
        }
    } 
    MotionType m_PreState = MotionType.Idle;



    private void Awake()
    {
    }

    private void Start()
    {
        //runSpeedFactor = defaultRunSpeedFactor;
        //SetAnimatorFloat(Anim_RunSpeed, runSpeedFactor);
    }


    private void OnDestroy()
    {
      
    }
    
    /// <summary>
    /// 直接播放动画
    /// </summary>
    /// <param name="anim"></param>
    void PlayAnim(string anim)
    {
        if (string.IsNullOrEmpty(anim)) { return; }
        
        AnimatorPlay(anim);
    }
    void PlayAnim(string anim, int layer, float time)
    {
        PlayAnim(anim, layer, time,true);
    }
    public void PlayAnim(string anim, int layer, float time,bool _playbackMode)
    {
        if (string.IsNullOrEmpty(anim)) { return; }
        
        AnimatorPlay(anim, layer, time);
        
    }

    MotionType StringToMotionType(string _value)
    {
        try
        {
            MotionType state = (MotionType)Enum.Parse(typeof(MotionType), _value);
            return state;
        }
        catch
        {
            Debug.LogError("StringToMotionType fail!  value:" + _value);

        }
        return MotionType.Idle;
    }


    /// <summary>
    /// 根据时间播放动画
    /// </summary>
    /// <param name="normalizeTime"></param>
    public void PlayerSliderValue(float normalizeTime)
    {
        SetAnimatorSpeed(0); 
        AnimatorPlay(animator.GetCurrentAnimatorStateInfo(0).fullPathHash, 0, normalizeTime);
    }

    /// <summary>
    /// 整体动作速度
    /// </summary>
    public float speed
    {
        get
        {
            if (animator != null)
            {
                return animator.speed;
            }
            return 1;
        }
        set
        {
            SetAnimatorSpeed(value);
        }
    }

    public void Pause()
    {
        this.speed = 0;
    }
    public void Resume()
    {
        this.speed = 1;
    }

    public void ResetAnimatorTrigger(string paramName)
    {
        if(animator != null)
            animator.ResetTrigger(paramName);
    }

    public void SetAnimatorTrigger(string paramName)
    {
        if (animator != null)
            animator.SetTrigger(paramName);
    }
    public void SetAnimatorBool(string paramName,bool value)
    {
        if (animator != null)
            animator.SetBool(paramName, value);
    }
    public void SetAnimatorInteger(string paramName, int value)
    {
        if (animator != null)
            animator.SetInteger(paramName, value);
    }
    public void SetAnimatorFloat(string paramName, float value)
    {
        if (animator != null)
            animator.SetFloat(paramName, value);
    }
    void AnimatorPlay(string anim)
    {
        AnimatorPlay(anim,0,0);
    }
    void AnimatorPlay(int animhash)
    {
        AnimatorPlay(animhash, 0, 0);
    }
    void AnimatorPlay(int animhash, int layer, float normalizeTime)
    {
        if (animator != null)
            animator.Play(animhash, layer, normalizeTime);
    }
    void AnimatorPlay(string anim,int layer,float normalizeTime)
    {
        if (animator != null)
            animator.Play(anim, layer, normalizeTime);
    }

    void AnimatorCrossFade(string anim,  float normalizeTransit)
    {
        if (animator != null)
            animator.CrossFadeInFixedTime(anim, normalizeTransit);
    }

    void SetAnimatorSpeed(float speed)
    {
        if (animator != null)
            animator.speed = speed;
    }
   

    
    // Update is called once per frame
    void Update ()
    {
        /*if (transform.childCount > 0)
        {
            if (Model.transform.localPosition.magnitude != 0)
            {
                Model.transform.localPosition = Vector3.zero;
            }
        }*/

    }





}

