﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public partial class RoleController : MonoBehaviour
{
    public float defaultScale = 1;

    [SerializeField] int m_RoleId;

    public int roleId
    {
        get { return m_RoleId; }
    }

    /// <summary>
    /// 角色动作控制
    /// </summary>
    [SerializeField]
    RoleMotion m_RoleMotion;
    public RoleMotion roleMotion { get { return m_RoleMotion; } }

    [SerializeField] private GameObject m_Model;

    public GameObject Model
    {
        get
        {
            if (m_Model != null)
                return m_Model;
            
            if (transform.childCount > 0)
                return transform.GetChild(0).gameObject;
            else
                return gameObject;
        }
    }

    public Renderer faceRenderer;

    /*[SerializeField] private GameObject m_MoveNode;

    public GameObject moveRoot => m_MoveNode;*/
    
    private Rigidbody[] m_Rigidbody;

    private Animator m_Animator;
    public Animator Animator
    {
        get
        {
            if (m_Animator == null)
                m_Animator = GetComponentInChildren<Animator>();
            return m_Animator;
        }
        set { m_Animator = value; }
    }
    
    public GameObject dieGo;

    private void Awake()
    {
        transform.localScale = Vector3.one * defaultScale;

        //Model.SetActive(true);
        if(dieGo)
            dieGo.SetActive(false);
    }

    // Use this for initialization
    void Start()
    {
        m_Rigidbody = GetComponentsInChildren<Rigidbody>();

        if (m_RoleMotion == null)
            m_RoleMotion = GetComponent<RoleMotion>();
    }
    
    
    /*public void SetPosition(Vector3 pos)
    {
        transform.position = pos;
            
        if(this.moveRoot)
            this.moveRoot.transform.position = pos;
            
        if(this.Model)
            this.Model.transform.position = pos;
    }*/
    
/*
    public void StopMove()
    {
        m_Rigidbody?.ForEach((e) =>
        {
            //m_Rigidbody.isKinematic = true;
            e.velocity = Vector3.zero;
        });

    }

    public void ResetRigidbodyVelocity()
    {
        m_Rigidbody?.ForEach((e) =>
        {
            e.velocity = Vector3.zero;
        });
    }
    */

    
    TransformAnim transformAnim
    {
        get
        {
            var ta = GetComponent<TransformAnim>();
            if (ta == null) ta = gameObject.AddComponent<TransformAnim>();
            return ta;
        }
    }

    public const int FaceType_Normal = 0;
    public const int FaceType_Angry = 1;

    public Texture faceSprNormal; 
    public Texture faceSprAngry;

    public void ShowFace(int type)
    {
        if (type == FaceType_Normal)
        {
            this.faceRenderer.material.mainTexture = faceSprNormal;
        }
        else  if (type == FaceType_Angry)
        {
            this.faceRenderer.material.mainTexture = faceSprAngry;
        }
    }
    
    #region action
    
    private static readonly int Attack1 = Animator.StringToHash("Attack");

    [ContextMenu("Die")]
    public void Die()
    {
        dieGo.SetActive(true);
        Destroy(Model.gameObject);
        m_Model = null;

        Invoke("OnDieSetRigidbody",2);
       // OnDieSetRigidbody();
    }
    void OnDieSetRigidbody()
    {
        GameDebug.LogError("OnDieSetRigidbody");
        if (dieGo)
        {
            var rigidbodies = this.dieGo.GetComponentsInChildren<Rigidbody>();
            for (int i = 0; i < rigidbodies.Length; i++)
            {
                rigidbodies[i].mass = 0.01f;
            }
        }
    }
    
    public void Attack()
    {
        this.Animator.SetTrigger(Attack1);
    }
    
    public void AttackOneFrame(float attackProgress)
    {
        throw new System.NotImplementedException();
    }
    #endregion

    void Update()
    {
        /*if(this.Animator)
            this.Animator.transform.localPosition = Vector3.zero;*/
        
    }

}
