using UnityEditor;
using UnityEngine;

[CustomEditor(typeof( HoppingDataConfig))]
public class HoppingDataConfigInspector:Editor
{
    public override void OnInspectorGUI()
    {
        
        HoppingDataConfig _this = target as HoppingDataConfig;

        if (_this != null)
        {
            _this.maxLevel = EditorGUILayout.IntField("最大关卡数", _this.maxLevel);
            _this.genInterval = EditorGUILayout.FloatField("生成球的时间间隔", _this.genInterval);
        }

        base.OnInspectorGUI();
        
        if (GUI.changed)
        {
            EditorUtility.SetDirty(target);
        }
    }
    
}