using UnityEngine;

public abstract partial class BattleBuff
{
    protected BattleController m_Controller;
    public BattleController battleController => m_Controller;
    
    protected RoleEntity m_Role;
    public RoleEntity role => m_Role;

    public abstract bool expired { get; }

    public string name => this.GetType().Name;
    
    private bool m_Started;

    public BattleBuff(RoleEntity role, BattleController controller)
    {
        m_Role = role;
        m_Controller = controller;
        m_Started = false;
    }

    /// <summary>
    /// 强制删除
    /// </summary>
    public virtual void SetExpired()
    {
        
    }

    public virtual void Start()
    {
        
    }
    
    public virtual void Update()
    {
        if (!m_Started)
        {
            m_Started = true;
            Start();
        }
    }

    public virtual void OnExpired()
    {
        
    }
}

public class BattleBuffLifeTime : BattleBuff
{
    /// <summary>
    /// 开始时间
    /// </summary>
    protected float m_StartTime;
    /// <summary>
    /// 当前时间
    /// </summary>
    public float curTime { get { return this.battleController.time - m_StartTime; } }

    /// <summary>
    /// 总时间
    /// </summary>
    protected float m_TotalTime;
    /// <summary>
    /// 总时间
    /// </summary>
    public float totalTime { get { return m_TotalTime; } }

    /// <summary>
    /// 是否已过期 已过去 则删除对象
    /// </summary>
    public override bool expired { get { return this.curTime > m_TotalTime; } }

    /// <summary>
    /// 强制结束
    /// </summary>
    public override void SetExpired()
    {
        m_TotalTime = 0;
    }

    public float progress
    {
        get
        {
            if (m_TotalTime <= 0)
            {
                return 1;
            }

            return Mathf.Clamp01(this.curTime / m_TotalTime);
        }
    }
    public BattleBuffLifeTime ( BattleController controller,RoleEntity role,float lifeTime) : base(role, controller)
    {
        m_StartTime = controller.time;
        m_TotalTime = lifeTime;
    }
    
    
}

public class BattleBuffDamage : BattleBuffLifeTime
{
    public int damage;
    public RoleEntity attacker;
    public RoleEntity receiver;
    
    public BattleBuffDamage(BattleController controller,RoleEntity role, float lifeTime,RoleEntity attacker,RoleEntity receiver,int damage) : base(controller,role, lifeTime)
    {
        this.damage = damage;
        this.attacker = attacker;
        this.receiver = receiver;
    }
}

