using System.Runtime.InteropServices.WindowsRuntime;

public abstract class ActionTransition : Transition
{
    protected  ActionFSMState fromAction => this.from as ActionFSMState;
    protected  ActionFSMState toAction => this.to as ActionFSMState;

    protected RoleEntity role => toAction.role;
    
    protected ActionTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    } 
    protected ActionTransition( ActionFSMState to) : base(null, to)
    {
        
    }
}

/// <summary>
/// normal -> jumpToLevel
/// </summary>
public class MeetSignTransition : ActionTransition
{
    private int m_Sign;
    
    public MeetSignTransition(int sign, ActionFSMState to) : base( to)
    {
        m_Sign = sign;
    }

    public override bool meedSign(int sign)
    {
        /*if(sign == PlayerState.climb)
            GameDebug.LogError($"climb sign:{sign}");*/
        return sign == m_Sign;
    }
}

public class Idle2RunTransition : ActionTransition
{
    public Idle2RunTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    }

    public override bool meedCondition()
    {
        //GameDebug.LogError($" this.role.moveVec.sqrMagnitude:{ this.role.moveVec.sqrMagnitude}");
        return this.role.moveVec.sqrMagnitude > 0;
    }
}
/// <summary>
/// run -> idle
/// </summary>
public class Run2IdleTransition : ActionTransition
{
    public Run2IdleTransition(ActionFSMState @from, ActionFSMState to) : base(@from, to)
    {
        
    }

    public override bool meedCondition()
    {
        return this.role.moveVec.sqrMagnitude <= 0;
    }
}
/// <summary>
/// ant -> byHit
/// </summary>
public class Any2ByHitTransition : ActionTransition
{
    public Any2ByHitTransition(ActionFSMState from ,ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedSign(int sign)
    {
        return sign == PlayerState.byHit;
    }
}

/// <summary>
/// 过程型动作过渡
/// </summary>
public class ProgressActionTransition:ActionTransition
{
    public ProgressActionTransition(ProgressActionFSMState from, ActionFSMState to) : base(from, to)
    {
        
    }

    public override bool meedCondition()
    {
        ProgressActionFSMState from = this.from as ProgressActionFSMState;

        return from.finished;
    }
}

public class Any2DieTransition : ActionTransition
{
    public Any2DieTransition( ActionFSMState to) : base( to)
    {
        
    }

    public override bool meedCondition()
    {
        return this.role.dead;
    }
}

/// <summary>
/// ant -> attack
/// </summary>
public class Any2AttackTransition : ActionTransition
{
    public Any2AttackTransition(ActionFSMState to) : base(to)
    {
        
    }

    public override bool meedSign(int sign)
    {
        return sign == PlayerState.policeAttack;
    }
}
