﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[Serializable]
public class PersonalResultPanelData
{
    public bool win;
    public string playerName;
    public int coin;
    public int level;
    public int star;
    //public int equipCount;
}

/// <summary>
/// 个人结果界面
/// </summary>
public class ResultUIDisplayController : DisplayController, IResultSceneUI
{


    public const float loadNextPanelTime = 4;
    [SerializeField]
    PersonalResultPanelData m_Data;

    ResultSceneUI m_PersonalResultPanel;

    public void Init(PersonalResultPanelData data)
    {
        m_Data = data;
    }

    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();
        
        if (m_PersonalResultPanel == null)
        {
            var pref = GameResourceManager.Load<ResultSceneUI>(DisplayDefine.ResultPanel);
            m_PersonalResultPanel = Instantiate(pref, transform);
            m_PersonalResultPanel.uiListener = this;
        }

        m_PersonalResultPanel.Init(m_Data);
        
        if (m_Data.win)
        {
            AudioManager.instance.PlayBattleSound(Audio.me_win,transform.position);
        }
        else
        {    
            //Game.Instance.audioManager.PlayBattleSound(Audio.me_lose,transform.position);
        }
    }

    public void OnProgressAnimEnd()
    {
        GameDebug.Log($"OnProgressAnimEnd  m_Data.level:{m_Data.level}");
    }

    public void OnClickGoBack()
    {
        
    }

    /// <summary>
    /// 失败再挑战一次
    /// </summary>
    public void OnClickAgain()
    {
        Game.Instance.LoadCurLevelGame();
    }


    /// <summary>
    /// 失败看广告跳过
    /// </summary>
    public void OnClickSkip()
    {
        GameDebug.Log($"观看广告跳关");
#if UNITY_EDITOR
        OnSkip();
        return;
#endif
/*        Game.Instance.audioManager.PauseMusic();

        Game.Instance.adController.ShowVideoAd(()=>
            {
                Game.Instance.audioManager.ResumeMusic();
                OnSkip();
            }, (err) => 
            {
                Game.Instance.audioManager.ResumeMusic();
                Game.Instance.ShowNoticePanel(err);
            }
            , ()=> 
            {
                Game.Instance.audioManager.ResumeMusic();
            });*/
    }

    void OnSkip()
    {
        /*Game.Instance.NextLevel();
        Game.Instance.LoadCurLevelGame();*/
    }

    public void OnClickAdMulti()
    {
        GameDebug.Log("播放广告");
#if UNITY_EDITOR
        OnAdMulti();
        return;
#endif
/*        Game.Instance.audioManager.PauseMusic();

        Game.Instance.adController.ShowVideoAd(()=>
        {
            Game.Instance.audioManager.ResumeMusic();
            OnAdMulti();
        }, (err) => 
        {
            Game.Instance.audioManager.ResumeMusic();
            Game.Instance.ShowNoticePanel(err);
        }
        , ()=> 
        {
            Game.Instance.audioManager.ResumeMusic();
        });*/
    }

    /// <summary>
    /// 胜利继续
    /// </summary>
    public void OnClickNext()
    {
        Game.Instance.NextLevel();
        Game.Instance.LoadCurLevelGame();
    }
    
    void OnAdMulti()
    {
        const int multi = 10;
        
        int coinAdd = m_Data.coin * (multi - 1);
        Game.Instance.user.UpdateCoin(Game.Instance.user.coin + coinAdd);
        
        if (this.m_PersonalResultPanel)
        {
            this.m_PersonalResultPanel.HideAdMultiBtn();

            this.m_PersonalResultPanel.SetAddScore(m_Data.coin * multi);
        }

        m_Data.coin *= multi;
        
/*        var resultScene = GetComponentInParent<ResultSceneDisplayController>();
        resultScene.OnAdMulti(multi);*/
    }


    public override void OnDelete()
    {
        base.OnDelete();

        if (m_PersonalResultPanel)
        {
            m_PersonalResultPanel.Release();
            Destroy(m_PersonalResultPanel.gameObject);
        }
    }

    private void OnDestroy()
    {
        m_Data = null;
    }


    /*void LoadNextPanel()
    {
        beginLoadingNextTime = Time.realtimeSinceStartup;
        
        InLoadingNextPanel = true;
    }




    private bool InLoadingNextPanel;
    private float beginLoadingNextTime;

    protected override void _Update()
    {
        if (InLoadingNextPanel)
        {
            if (Time.realtimeSinceStartup - beginLoadingNextTime > loadNextPanelTime)
            {
                InLoadingNextPanel = false;
                
                ResultSceneDisplayController resultScene = GetComponentInParent<ResultSceneDisplayController>();
                
                resultScene.GotoMainScene();
            }
            
        }
    }*/
}