using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class SettingUI : UICommon
{
    public bool musicOn;
    public bool soundOn;
    public bool vibrationOn;

    //public LanguageType LanguageType;

    public Toggle musicToggle;
    public Toggle soundToggle;
    public Toggle vibrationToggle;

    private bool m_InInit;
    public void Init()
    {
        m_InInit = true;
        
        this.musicOn = musicToggle.isOn = Game.Instance.gameSetting.bgMusic;
        this.soundOn = soundToggle.isOn = Game.Instance.gameSetting.soundEffect;
        this.vibrationOn = vibrationToggle.isOn = Game.Instance.gameSetting.vibration;
        //this.LanguageType = LanguageTypeSet.language;
        
        m_InInit = false;
    }

    
    public void OnMusicToggle(bool isOn)
    {
        if (m_InInit) return;
        
        GameDebug.Log($"设置音乐开关：{isOn}");
       
        this.musicOn = isOn;
    }

    public void OnSoundToggle(bool isOn)
    {
        if (m_InInit) return;
        
        GameDebug.Log($"设置音效开关：{isOn}");
        this.soundOn = isOn;
    }

    public void OnVibrationToggle(bool isOn)
    {
        if (m_InInit) return;
        
        GameDebug.Log($"设置震动开关：{isOn}");
        this.vibrationOn = isOn;
    }

    public void OnClickConfirm()
    {
        Game.Instance.gameSetting.soundEffect = soundOn;
        Game.Instance.gameSetting.vibration = this.vibrationOn;
        
        if (!Game.Instance.gameSetting.bgMusic && musicOn)
        {
            AudioManager.instance.StopAllMusic();
            var homeMusic = GameResourceManager.Load<AudioClip>(GameResourceManager.battleSceneMusic);
            AudioManager.instance.Play(homeMusic, Vector3.zero, true, null, true);
        }
        else if (Game.Instance.gameSetting.bgMusic && !musicOn)
        {
            AudioManager.instance.StopAllMusic();
        }
        Game.Instance.gameSetting.bgMusic = musicOn;

        this.GoBack();
        //LanguageTypeSet.language = LanguageType;
    }

    protected override void GoBackToDisplay()
    {
        m_Controller.parentNav.LoadDisplay<BattleUIDisplayController>();
    }
// Update is called once per frame

}