using System;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;
using UnityEngine.UI;

[RequireComponent(typeof(Battle3DScene))]
public class BattleSceneEditorTest : MonoBehaviour
{
    private EditorTestUI m_UI;
    protected Battle3DScene battle3DScene => GetComponent<Battle3DScene>();
    protected BattleController m_Controller;
    public BattleController battleController => m_Controller;

    private AudioManager m_AudioManager;

    protected const int testPlayerId = 0;

    private Battle3DScene m_Backup;

    protected virtual void Start()
    {
        m_Backup = Instantiate(gameObject).GetComponent<Battle3DScene>();
        m_Backup.gameObject.SetActive(false);
        
        Init();

        //m_Controller.GameStart();
    }
    

    [ContextMenu("Restart")]
    public void Restart()
    {
        GameDebug.LogError("重新开始");
        Destroy(m_Controller.gameObject);
        m_Backup.gameObject.SetActive(true);
    }


    [ContextMenu("TestEnd")]
    void TestEnd()
    {
        m_Controller.onBattleFinish?.Invoke(new BattleResult());
    }

    public EditorTestUI testUIPref;
    void Init()
    {
        m_Controller = NewBattleController();

        if (testUIPref)
        {
            m_UI = Instantiate(testUIPref, m_Controller.transform);
            m_UI.Init(this);
        }
        else
        {
            GameDebug.LogError("testUIPref == null");
        }

        m_AudioManager = new GameObject("AudioManager").AddComponent<AudioManager>();
        m_AudioManager.transform.SetParent(transform);
        
        battle3DScene.transform.SetParent(m_Controller.transform);
        battle3DScene.Init(m_AudioManager,null);
        
        InitBattle(GetTestData());
    }

    protected virtual BattleController NewBattleController()
    { 
        var battleContoller = new GameObject("BattleController").AddComponent<BattleController>(); 
        transform.SetParent(battleContoller.transform);
        return battleController;
    }
    
    protected virtual BattleData GetTestData()
    {
        BattleData battleData = new BattleData();
        battleData.mapData = new BattleMapData();
        battleData.mapData.mapId = battle3DScene.mapId;
        return battleData;

        /*int mapId = battle3DScene.mapId;
        
        battleData.mapData = Battle3DScene.LoadLocalData(mapId);
       
        GameDebug.LogShowy($"mapEdit count:{battleData.mapData.mapEditWidgets?.Count}  宝箱有:{battleData.mapData.mapEditWidgets?.AllWhere(e=>e.entityType == EntityType.goldBox).AsList().Count}");

        battleData.players = new List<BattlePlayerData>();
        battleData.players.Add(new BattlePlayerData()
        {
            playerId = testPlayerId,
            name = "test",
            roleId = 1,
            props = null,
            equipCount = 0,
            speed = 3,
            pickUpRange = 0.35f
        });
        
        return battleData;*/
    }
    


    protected virtual void InitBattle(BattleData data)
    {
        try
        {
            m_Controller.Init(data, testPlayerId, battle3DScene);
            m_Controller.GameStart();
            
        }
        catch (Exception e)
        {
            GameDebug.LogError(gameObject.name);
            GameDebug.LogError(battle3DScene != null);
            GameDebug.LogError(m_Controller != null);
            GameDebug.LogError(e);
        }

    }
    
}