﻿
#if UNITY_EDITOR
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using UnityEngine;
using UnityEditor;

public static class Battle3DSceneTools
{
    [UnityEditor.MenuItem("Dyspace/保存场景中激活的关卡预设")]
    static void SaveAllBattle3DSceneInScene()
    {
        List<Battle3DScene> scenes = GameObject.FindObjectsOfType<Battle3DScene>().AsList();// FindSceneObject<Battle3DScene>();// GetAllSceneObjectsWithInactive(typeof(Battle3DScene));

        GameDebug.Log($"场景中有关卡：{scenes.Count}个");

        int index = 0;
        
        if (scenes.Count > 0)
        {
            SaveScene(0, scenes);
        }
        
        /*for (int i = 0; i < scenes.Count; i++)
        {
            Battle3DScene battle3DScene = scenes[i].GetComponent<Battle3DScene>();

            scenes.ForEach(e => e.gameObject.SetActive(false));

            battle3DScene.gameObject.SetActive(true);

            battle3DScene.Save();
        }*/
    }

    static void SaveScene(int index,List<Battle3DScene> battle3DScenes)
    {
        Battle3DScene battle3DScene = battle3DScenes[index].GetComponent<Battle3DScene>();

        battle3DScenes.ForEach(e => e.gameObject.SetActive(false));

        battle3DScene.gameObject.SetActive(true);

        battle3DScene.Save(() =>
        {
            index++;
            
            if(index < battle3DScenes.Count)
                SaveScene(index,battle3DScenes);
        });
    }
    
    //static List<T> FindSceneObject<T>() where T : UnityEngine.Component
    //{
    //    List<T> objectsInScene = new List<T>();
    //    foreach (var go in Resources.FindObjectsOfTypeAll<T>())
    //    {
    //        if (go.hideFlags == HideFlags.NotEditable || go.hideFlags == HideFlags.HideAndDontSave)
    //            continue;
    //        if (EditorUtility.IsPersistent(go.transform.root.gameObject))// 如果对象位于Scene中，则返回false
    //            continue;

    //        //if (_SceneName != go.gameObject.scene.name)
    //        //    continue;

    //        Debug.LogFormat("gameObject:{0},scene:{1}", go.gameObject.name, go.gameObject.scene.name);
    //        objectsInScene.Add(go);
    //    }
    //    return objectsInScene;
    //}
    
}



#endif