﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;


[RequireComponent(typeof(Text))]
public class NumShow : MonoBehaviour {

    public Text m_NumText;
     
    float m_CurShowNum;
    float m_Num = -1;
    public float num
    {
        get
        {
            return m_Num;
        }
        set
        {
            if (value != m_Num)
            {
                float delta = value - m_Num;
                float speed = delta < 30 ? 1 : delta / 30;
                m_Num = value;

                if(gameObject.activeInHierarchy)
                    StartCoroutine(PlayAddToNum(m_CurShowNum, m_Num, speed));
                else
                    SetText(m_Num);

                m_CurShowNum = m_Num;
            }
        }
    }
    string prefix = "";
    string suffix = "";
    int m_Round;

    public bool playDefaultAudio = false;

    void Awake()
    {
        if(m_NumText == null)
            m_NumText = GetComponent<Text>();
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="num">初始数字</param>
    /// <param name="prexStr">前缀</param>
    /// <param name="round">精度</param>
    public void Init(float num,string prexStr, string suffStr, int round)
    {
        this.m_Num = num;
        this.m_CurShowNum = num;
        prefix = prexStr;
        suffix = suffStr;
        m_Round = round;

        SetText(num);
    }

	// Use this for initialization
	void Start () {
		
	}

    private void OnDestroy()
    {
        
    }

    public void SetTextColor(Color color)
    {
        this.m_NumText.color = color;
    }

    IEnumerator PlayAddToNum(float curNum,float targetNum,float speed)
    {
        while (curNum < targetNum)
        {
            curNum += speed;

            SetText(curNum);
            yield return 0;
        }
        
        curNum = targetNum;
        SetText(curNum);
    }

    public int testAddNum = 100;
    [ContextMenu("TestAdd10")]
    void TestAdd10()
    {
        this.num += testAddNum;
    }

    void SetText(float num)
    {
        SetText(num,this.prefix,this.suffix,this.m_Round);
    }


    void SetText(float num,string prefix,string suffix,int round)
    {
        string numStr = "";
        if (round == 0)
        {
            numStr = prefix + (int)num + suffix;
        }
        else if (m_Round > 0)
        {
            int power = (int)Mathf.Pow(10, m_Round);
            int p = (int)(num * power);
            numStr = prefix +((float)p / power)+ suffix;
        }

        if (m_NumText)
            m_NumText.text = numStr;
    }
	
	// Update is called once per frame
	void Update () {
		
	}
}
