﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class NoticePanelData
{
    public string title;
    public string content;
    public Sprite iconSpr;
    public string btnLeftTxt;
    public string btnRightTxt;
    public Action onConfirm;
    public Action onCancel;
    public bool selfClose = true;

    void Init(string _title, string _content,Sprite _secondContent, string _btnConfirmText, string _btnCancelText, Action _onConfirm, Action _onCancel,bool _selfClose)
    {
        this.title = _title;
        this.content = _content;
        this.btnLeftTxt = _btnCancelText;
        this.btnRightTxt = _btnConfirmText;
        this.iconSpr = _secondContent;
        this.selfClose = _selfClose;
        onConfirm = _onConfirm;
        onCancel = _onCancel; 
    }
    public NoticePanelData(string _title, string _content, Sprite _secondContent, string _btnConfirmText, string _btnCancelText, Action _onConfirm, Action _onCancel)
    {
        Init(_title, _content, _secondContent, _btnConfirmText, _btnCancelText, _onConfirm, _onCancel,true);
    }
    public NoticePanelData(string _title,string _content, string _btnConfirmText, string _btnCancelText,Action _onConfirm, Action _onCancel)
    {
        Init(_title, _content,null, _btnConfirmText, _btnCancelText, _onConfirm, _onCancel, true);
    }
    public NoticePanelData(string _title, string _content, string _btnConfirmText, string _btnCancelText, Action _onConfirm, Action _onCancel, bool _selfClose)
    {
        Init(_title, _content, null, _btnConfirmText, _btnCancelText, _onConfirm, _onCancel, _selfClose);
    }
    public NoticePanelData(string _title, string _content, string _btnText, Action _onConfirm)
    {
        Init(_title, _content, null, _btnText,"", _onConfirm,null, true);
    }
    
}

public class NoticePanel : UICommon
{
    public Text titleText;
    public Text contentText;
    //public Text secondContentText;
    public Text btnLeftText;
    public Text btnRightText;
    
    public Image icon;

    //public GameObject leftBtnGo;

    Action m_OnConfirm;
    Action m_OnCancel;
    bool m_SelfClose;

    bool m_IsShowing;
    public bool isShowing => m_IsShowing;

    public AnimationCurve largenCurve;
    public AnimationCurve smallenCurve;

    public GameObject doubleBtnGo;
    public GameObject singleBtnGo;
    
    [SerializeField]
    TransformAnim m_TransformAnim;

    [SerializeField]
    Transform m_WidgetsParent;

    public bool useDefaultUICanvas = true;
    
    public override void Awake()
    {
        if (useDefaultUICanvas)
        {
            base.Awake();
            this.m_Canvas.renderMode = RenderMode.ScreenSpaceOverlay;
            
            if (m_TransformAnim == null) m_TransformAnim = GetComponent<TransformAnim>();
            if (m_TransformAnim == null) m_TransformAnim = gameObject.AddComponent<TransformAnim>();

            if (m_WidgetsParent)
            {
                m_WidgetsParent.localScale = Vector3.zero;
                this.m_WidgetsParent.gameObject.SetActive(false);
            }
            
            if (m_BlackBG)
                m_BlackBG.gameObject.SetActive(false);
        }

    }

    // Use this for initialization
    public override void Start () {

        if (useDefaultUICanvas)
        {
            base.Start();

            //FadeInAnim();

            var rectTransform = GetComponent<RectTransform>();

            UIAnim.GetImgTxtAlpha(rectTransform, out imgAlphas, out txtAlphas, out rawAlphas);
        }
    }

    protected override void OnDestroy()
    {
        m_OnConfirm = null;
        m_OnCancel = null;
    }

    public override void FadeInAnim()
    {
        m_IsShowing = true;

        if (m_WidgetsParent)
        {
            this.m_WidgetsParent.gameObject.SetActive(true);
            if (m_BlackBG)
                m_BlackBG.gameObject.SetActive(true);

            var rectTransform = GetComponent<RectTransform>();
            //m_UIAnim.SetImgTxtAlpha(rectTransform, 0);

            m_UIAnim.InitCurve(fadeInCurve);
            m_UIAnim.UIAlpha(rectTransform, imgAlphas, txtAlphas, rawAlphas, fadeInTime, OnFadeInAimEnd,
                UIAnim.EaseType.Curve);

            m_TransformAnim.SetCurve(this.largenCurve);
            m_TransformAnim.ScaleTo(m_WidgetsParent, Vector3.one, this.fadeInTime, null);
        }
    }

    //public Action onHide;
    public override void FadeOut()
    {
        base.FadeOut();
        
        //onHide?.Invoke();
        
        m_IsShowing = false;
        

        if (m_WidgetsParent)
        {
            m_TransformAnim.SetCurve(this.smallenCurve);
            m_TransformAnim.ScaleTo(this.m_WidgetsParent, Vector3.zero, this.fadeOutTime, OnFadeOutAimEnd);

            Invoke("OnFadeOutAimEnd", fadeOutTime);
        }
    }

    protected override void OnFadeOutAimEnd()
    {
        base.OnFadeOutAimEnd();

        if (m_WidgetsParent)
            this.m_WidgetsParent.gameObject.SetActive(false);

        if (m_BlackBG)
            m_BlackBG.gameObject.SetActive(false);

    }

    public void Init(NoticePanelData data)
    {
        m_SelfClose = data.selfClose;
        m_OnConfirm = data.onConfirm;
        m_OnCancel = data.onCancel;
        
        titleText.text = data.title;
        contentText.text = data.content;
        btnRightText.text = data.btnRightTxt;

        if (data.iconSpr == null)
        {
            if(icon)
                icon.transform.parent.gameObject.SetActive(false);
        }
        else
        {
            if(icon)
                icon.sprite = data.iconSpr;
        }

        if (string.IsNullOrEmpty(data.btnLeftTxt))
        {
            doubleBtnGo.SetActive(false);
            singleBtnGo.SetActive(true);
        }
        else
        {
            btnLeftText.text = data.btnLeftTxt;
            doubleBtnGo.SetActive(true);
            singleBtnGo.SetActive(false);
        }
        
        this.FadeInAnim();
    }

    public void AddOnClickCallBack(Action onConfirm,Action onCancel)
    {
        m_OnConfirm += onConfirm;
        m_OnCancel += onCancel;
    }

    public void OnClickConfirm()
    {
        if(this.m_SelfClose)
            FadeOut();

        if (m_OnConfirm != null)
            m_OnConfirm();

    }

    public void OnClickCancel()
    {
        if (this.m_SelfClose)
            this.FadeOut();

        if (m_OnCancel != null)
            m_OnCancel();
    }

    protected override void GoBackToDisplay()
    {

    }

    //public new void GoBack()
    //{
    //    m_Controller.parentNav.GoBackToPreDC();
    //}

    // Update is called once per frame
    void Update () {
		
	}
}
