﻿#if UNITY_EDITOR
using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

[CustomEditor(typeof(CombineMesh))]
public class CombineMeshInspector : Editor {
	public override void OnInspectorGUI()
	{
		base.OnInspectorGUI();
		
		CombineMesh _this = target  as CombineMesh;

		if (_this)
		{
			if (GUILayout.Button("合并模型"))
			{
				if (!Application.isPlaying)
				{
					GameDebug.LogError("请在运行模式下执行");
					return;
				}
				_this.Init();
			}

			if (GUILayout.Button("保存模型"))
			{
				_this.SaveMeshPref();
			}
		}
	}
}

#endif