﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class MainSceneUIChangeAnim : DisplayControllerSwitchAnimation
{
    //目前仅作延迟销毁用


    GraphicRaycaster m_GraphicRaycaster;
    Canvas m_canvas;

    UIAnim uiAnim;
    public int sortingOrder = 100;
    public float fadeInTime = 0.4f;
    public float fadeOutTime = 0.4f;
    
    // Use this for initialization
    void Awake () {
        m_GraphicRaycaster = GetComponent<GraphicRaycaster>();
        m_canvas = GetComponent<Canvas>();
        uiAnim = GetComponent<UIAnim>();
        if (uiAnim == null) uiAnim = gameObject.AddComponent<UIAnim>();
    }

    protected override void PlayShowAnim(DisplayController dc, Action onAnimEnd)
    {
        m_GraphicRaycaster.enabled = true;

        if (onAnimEnd != null)
            onAnimEnd();
    }
    protected override void PlayInLoadingAnim(Action onEnd)
    {
        if (onEnd != null)
            onEnd();
    }

    protected override void PlayHideAnim( Action onAnimEnd)
    {
        Hide(() =>
        {
            if (onAnimEnd != null)
                onAnimEnd();
        });
    }

    public void Hide(Action onFinished)
    {
        m_canvas.sortingOrder = sortingOrder;

        if (m_GraphicRaycaster == null) m_GraphicRaycaster = GetComponent<GraphicRaycaster>();


        uiAnim.UIAlpha(transform.GetComponent<RectTransform>(), 0, fadeOutTime,()=>
        {
            onFinished?.Invoke();
            m_GraphicRaycaster.enabled = false;
            SetBlock(false);

        }, UIAnim.EaseType.Curve);
        

    }

    void SetBlock(bool block)
    {
        foreach (var img in GetComponentsInChildren<Image>())
        {
            img.raycastTarget = block;
        }
        foreach (var Text in GetComponentsInChildren<Text>())
        {
            Text.raycastTarget = block;
        }
    }
    

    // Update is called once per frame
    void Update () {
		
	}
}
