﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

public class EditorCommonFunctions {

    public static void SavePrefab<T>(string dataFilePath, System.Action<T> updateData) where T : MonoBehaviour
    {
        GameObject obj = null;
        GameObject dataPrefab = AssetDatabase.LoadAssetAtPath<GameObject>(dataFilePath);
        if (dataPrefab != null)
        {
            obj = GameObject.Instantiate(dataPrefab) as GameObject;
        }
        else
        {
            dataPrefab = PrefabUtility.CreateEmptyPrefab(dataFilePath) as GameObject;
            string fileName = System.IO.Path.GetFileNameWithoutExtension(dataFilePath);
            Debug.Log("fileName :" + fileName);
            obj = new GameObject(fileName);
            obj.AddComponent<T>();
        }
        updateData(obj.GetComponent<T>());

        PrefabUtility.ReplacePrefab(obj, dataPrefab);
        GameObject.DestroyImmediate(obj);

        AssetDatabase.Refresh();
    }
}
