﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

public class BattleJoinPadEvent : MonoBehaviour, IPointerDownHandler, IDragHandler, IPointerUpHandler
{
	public BattleJoinPad joinPad;

	const int noPointerId = -100;

	int m_PointerId = noPointerId;
	/// <summary>
	/// 位置记录
	/// </summary>
	Vector2 m_StartPos;
	float m_StartTime;

	Vector2 GetUGUIPosition (PointerEventData eventData)
	{
		Vector2 pos;
		RectTransformUtility.ScreenPointToLocalPointInRectangle(this.transform as RectTransform, eventData.position, eventData.pressEventCamera, out pos);
		return pos;
	}

	void Awake ()
	{
		if (this.joinPad == null)
		{
			this.joinPad = this.GetComponentInParent<BattleJoinPad>();
		}

		if (this.joinPad == null)
		{
			GameDebug.LogError("未发现BattleJoinPad");
		}

	}

	private void Start()
	{
		
		
	}

	public void OnPointerDown (PointerEventData eventData)
	{
		//GameDebug.Log("OnPointerDown   eventData.pointerId:{ eventData.pointerId}");
		
		if (m_PointerId == noPointerId)
		{
			// 标识为开始
			m_PointerId = eventData.pointerId;


			Vector2 startPosition = Input.mousePosition;// GetUGUIPosition(eventData);
			m_StartPos = startPosition;
			m_StartTime = Time.time;
			this.joinPad.SetPosition(startPosition);
            
            this.joinPad.OnFingerPointerDown();
        }

    }
    
    public const int limitMax = 80;//100;
    public const int limitMin = 10;//10;

    public void OnDrag (PointerEventData eventData)
    {
/*	    if (Time.frameCount % 2 != 0) 
			return;*/
		
		/*if (m_PointerId == eventData.pointerId)
		{
            //GameDebug.Log("Drag  JudgeAttackTime:"+ joinPad.battleUI.JudgeAttackTime);
            //Debug.Log("OnDrag: " + eventData.position);

            Vector2 position = GetUGUIPosition(eventData);
			Vector2 offset =  position - m_StartPos;

            // 范围限定
            float sqrMagnitude = offset.sqrMagnitude;
            
            if (sqrMagnitude > limitMax * limitMax)
            {
	            offset = offset.normalized * limitMax;
            }
            else if (sqrMagnitude < limitMin * limitMin)
            {
	            offset = Vector2.zero;
            }

            this.joinPad.SetBallOffset(offset);
		}*/
	}

	public void OnPointerUp (PointerEventData eventData)
	{
		if (m_PointerId == eventData.pointerId)
		{
			// 标识为结束
			m_PointerId = noPointerId;
            
            this.joinPad.ResetPosition(true);
        }
    }

	private void Update()
	{
		if (m_PointerId != noPointerId)
		{
			//GameDebug.Log("Drag  JudgeAttackTime:"+ joinPad.battleUI.JudgeAttackTime);
			//Debug.Log("OnDrag: " + eventData.position);

			Vector2 position = Input.mousePosition;//GetUGUIPosition(Input.mousePosition);
			Vector2 offset = position - m_StartPos;

			// 范围限定
			float sqrMagnitude = offset.sqrMagnitude;
            
			if (sqrMagnitude > limitMax * limitMax)
			{
				offset = offset.normalized * limitMax;
			}
			else if (sqrMagnitude < limitMin * limitMin)
			{
				offset = Vector2.zero;
			}

			this.joinPad.SetBallOffset(offset);
		}
	}
}
