﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class BattleJoinPad : MonoBehaviour
{
    public Transform joinPadView;
    public Image joinPadBall;

    [System.NonSerialized]
    public Vector3 initPos = new Vector3(0, -620, 0);

    public Action<Vector3> onPointerDown;
    public Action<Vector2> onMove;
    public Action<Vector3> onPointerUp;

    private void Start()
    {
        ResetPosition();
    }

    public void SetPosition(Vector2 position)
    {
        ShowView();
        this.joinPadView.localPosition = position;
    }

    public void ResetPosition()
    {
        this.ResetPosition(false);
    }

    public void ResetPosition(bool stopMove)
    {
        this.joinPadView.GetComponent<RectTransform>().anchoredPosition = initPos;//.localPosition = initPos;

        // 仅在停止时，方向小球回复初始位置
        if (stopMove)
        {
            this.joinPadBall.transform.localPosition = Vector3.zero;
            this.PostOptStopMove();
        }
        HideView();
    }

    float m_PointDownTime;
    public void OnFingerPointerDown()
    {
        m_PointDownTime = Time.realtimeSinceStartup;
        
        onPointerDown?.Invoke(Input.mousePosition);
    }

    public void SetBallOffset(Vector2 offset)
    {
        this.joinPadBall.transform.localPosition = offset;

        //this.PostOptMove(offset);

        this.PostOptMove(TransformMoveDir(offset));
    }

    private Vector2 TransformMoveDir(Vector2 dir)
    {
        float x = dir.x / BattleJoinPadEvent.limitMax;
        float y = dir.y / BattleJoinPadEvent.limitMax;

        //GameDebug.Log($"x:{x}  y:{y}");

        return new Vector2(x,y);
    }

    public void ShowView()
    {
        joinPadView.gameObject.SetActive(true);
    }
    public void HideView()
    {
        joinPadView.gameObject.SetActive(false);
    }


   
    /// <summary>
	/// 发送移动操作事件
    /// </summary>
    private void PostOptMove(Vector2 moveDir)
    {
        this.onMove?.Invoke(moveDir);
    }

    /// <summary>
    /// 发送移动停止事件
    /// </summary>
    private void PostOptStopMove()
    {
        this.onPointerUp?.Invoke(Input.mousePosition);
    }


    void OnDestroy()
    {
        
    }
}
