﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerState
{
    public const int idle = 1;
    public const int run = 2;
    public const int policeAttack = 3;
    public const int byHit = 4;
    public const int die = 5;
    public const int State_Win = 6;
    public const int State_Lose = 7;

    public static string GetStateName(int state)
    {
        switch (state)
        {
            case idle: return "idle";
            case run: return "run";
            case policeAttack: return "policeAttack";
            case byHit: return "byHit";
            case die: return "die";
            case State_Win: return "State_Win";
            case State_Lose: return "State_Lose";
        }
        return "";
    }
}

public partial class PlayerEntity : RoleEntity
{
    public override bool isTrigger => false;

    /// <summary>
    /// 分数
    /// </summary>
    private int m_Score;
    public int score => m_Score;

    /// <summary>
    /// 状态
    /// </summary>
    public int state => curAction?.ID ?? PlayerState.idle;

    public string GetStateName() => PlayerState.GetStateName(state); 
    

    private TranslateAnim m_TranslateAnim;
    public TranslateAnim translateAnim
    {
        get
        {
            if (m_TranslateAnim == null)
            {
                m_TranslateAnim = gameObject.AddComponent<TranslateAnim>();
            }
            return m_TranslateAnim;
        }
    }

    private HoppingBattleController m_HoppingBattleController;
    public HoppingBattleController hoppingBattleController
    {
        get
        {
            if(m_HoppingBattleController == null)
                m_HoppingBattleController = this.battleController as HoppingBattleController;
            return m_HoppingBattleController;
        }
    }


    public bool win => curAction.ID == PlayerState.State_Win;
    
    protected  override void Start()
    {
       base.Start();
    }

    public void Init(HoppingDataConfig dataConfig)
    {
        Init(this.m_PlayerId, dataConfig);
    }
    public void Init(long playerId,HoppingDataConfig dataConfig)
    {
        this.m_PlayerId = playerId;
        
        m_ActionFSMSystem = ActionFSMSystem.InitPlayerActionFSM(this);
        
        GameDebug.LogError($"player init:{m_ActionFSMSystem != null}");
    }

    protected override void RegisterBuffProcessor(WidgetMultiStateDispacher<BattleBuff> dispacher)
    {
        base.RegisterBuffProcessor(dispacher);
        
        dispacher.AddProcessor(typeof(BattleBuffDamage), new OnDamageProcessor());
    }

    /// <summary>
    /// 获得分数
    /// </summary>
    /// <param name="score"></param>
    public void AddScore(int score)
    {
        m_Score += score;
        
        GameDebug.Log($"获得分数：{score}");
    }

    /// <summary>
    /// 胜利
    /// </summary>
    public void OnWin()
    {
        if (state != PlayerState.State_Win)
        {
            //state = PlayerState.State_InJumpToLevel;
            this.m_ActionFSMSystem.InputSign(PlayerState.State_Win);

        }
    }
    
    protected  override void Update()
    {
        //base.Update();
        
        //更新动作
        if (m_ActionFSMSystem != null)
        {  
            //GameDebug.LogError($"m_ActionFSMSystem  Update"); 
            m_ActionFSMSystem.Update();
        }
        else
        {
            GameDebug.LogError($"m_ActionFSMSystem is null");
        }
        if (!hoppingBattleController) return;
        
        ClampPos();
    }

    bool InCanMoveState(int state)
    {
        return state == PlayerState.idle || state == PlayerState.run;
    }
   
    private void ClampPos()
    {
        var pos = transform.position;
        pos = hoppingBattleController.ClampPos(pos,0.5f);
        transform.position = pos;
    }

    private void FixedUpdate()
    {
        if (InCanMoveState(state))
        {
            if (Rigidbody)
            {
                var dir = moveVec.normalized;
                dir.y = 0;
                this.Rigidbody.velocity = this.speed * dir;
                transform.rotation = this.FocusTo(transform.position + dir);
            }
        }
        else if (state == PlayerState.State_Win)
        {
            
        }
    }

    public Vector3 climbDir { get; set; }

    //private bool m_ClimbUp;
    public void OptMove(Vector3 vec)
    {
        if (state == PlayerState.run || state == PlayerState.idle)
        { 
            SetMoveVec(new Vector3(vec.x,0,vec.y));//SetMoveVec(new Vector3(-vec.y,0,vec.x));

            /*var dir = new Vector3(vec.x,0,vec.y);

            var odir = dir;
                
            dir = hoppingBattleController.HoppingBattle3DScene.camerasManager.curCam.cam.transform
                .TransformDirection(dir);
            dir.y = 0;
            
            SetMoveVec(dir.normalized);*/
            
        }
    }

    public void OptStopMove()
    {
        StopMove();
    }
}