using System;
using UnityEngine;

public class MatchStick : MonoBehaviour
{
    public Transform beginPosTrans;
    public Transform endPosTrans;
    
    public Vector3 beginPos => beginPosTrans.position;
    public Vector3 endPos => endPosTrans.position;
    
    public Renderer renderer;

    private void Start()
    {
        if (renderer == null)
            renderer = GetComponent<Renderer>();
        
        renderer.material.SetVector("_FillBeginPos",beginPos);
        renderer.material.SetVector("_FillEndPos",endPos);
    }

    public void SetFillValue(float value)
    {
        renderer.material.SetVector("_FillBeginPos",beginPos);
        renderer.material.SetVector("_FillEndPos",endPos);
        
        renderer.material.SetFloat("_FillValue",value);
    }
}