﻿using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using UnityEngine;

public class MatchEntity : ViewEntity
{
    private int m_State = State_Normal;
    public const int State_Normal = 0;
    public const int State_InFire = 1;
    public const int State_FireEnd = 2;
    public const int State_InRotate= 3;
    
    public Transform firePos;
    public GameObject fireFX;

    public Transform stickTrans;
    public MatchStick normalMatchStick;  
    public MatchStick firedMatchStick;
    
    private Vector3 beginPos => normalMatchStick.beginPos;
    private Vector3 endPos => normalMatchStick.endPos;
    
    public float fireSpeed;
    public ColliderTrigger head;

    float m_FireTime;
    
    
    // Start is called before the first frame update
    void Start()
    {
        HideFireFX();
        normalMatchStick.SetFillValue(0);
        firedMatchStick.SetFillValue(1);
        firedMatchStick.gameObject.SetActive(false);

        head.onTriggerEnter = OnHeadTrigger;
    }

    private void OnHeadTrigger(Collider obj)
    {
        if (m_State != State_Normal) return;
        
        //GameDebug.LogError($"OnHeadTrigger:{obj.name}");
        
        if (obj.gameObject.layer == HoppingBattleController.layerTrigger)
        {
            Fire();
        }
    }

    [ContextMenu("Fire")]
    public void Fire()
    {      
        if (m_State != State_Normal) return;

        //GameDebug.Log($"Fire!");
        
        if (fireSpeed >= 0)
        {
            m_State = State_InFire;
            m_BeginFireTime = Time.time;
            m_FireTime = (endPos - beginPos).magnitude / fireSpeed;

            ShowFireFX();
            firedMatchStick.gameObject.SetActive(true);
            head.gameObject.SetActive(false);
        }
    }

    public void Rotate()
    {
        if (m_State != State_Normal) return;
        
        m_State = State_InRotate;
        var stick = stickTrans.transform;
        var rot = stick.localRotation.eulerAngles;
        rot.y += 180;
        transformAnim.RotateTo(stick, rot, .5f, () =>
        {
            m_State = State_Normal;
            
        }, true, true);
    }
    
    void ShowFireFX()
    {
        fireFX.gameObject.SetActive(true);
    }

    void HideFireFX()
    {
        fireFX.gameObject.SetActive(false);
    }

    public bool inFire => m_State == State_InFire;
    public bool fired => m_State == State_FireEnd;
    public int state => m_State;

    private float m_BeginFireTime;

    private TransformAnim m_TransformAnim;
    TransformAnim transformAnim
    {
        get
        {
            if (m_TransformAnim == null)
                m_TransformAnim = gameObject.AddComponent<TransformAnim>();
            
            return m_TransformAnim;
        }
    }

    
    public float testValue;
    // Update is called once per frame
    void Update()
    {
        if (!firePos || !normalMatchStick || !firedMatchStick || m_FireTime <= 0) return;
        
        if (inFire)
        {
            float time = Time.time - m_BeginFireTime;
            float value = time / m_FireTime;
            testValue = value;
            var pos = Vector3.Lerp(beginPos, endPos, value);

            normalMatchStick.SetFillValue(value);
            firedMatchStick.SetFillValue(1-value);
            
            firePos.position = pos;
            if (time >= m_FireTime)
            {
                m_State = State_FireEnd;
                HideFireFX();
            }
        }
    }

}