using System.Collections.Generic;
using UnityEngine;

public class HoppingEditorTestUI: EditorTestUI
{
    HoppingBattleController hoppingBattleController => this.m_BattleSceneEditorTest.battleController as HoppingBattleController;
    
    public BattleJoinPad touchPad;

    protected override void Awake()
    {
        base.Awake();
        if (touchPad)
        {
            touchPad.onMove = OnPointerMove;
            touchPad.onPointerDown = OnPointerDown;
            touchPad.onPointerUp = OnPointerUp;
        }
    }

    public override void Init(BattleSceneEditorTest battleSceneEditorTest)
    {
        base.Init(battleSceneEditorTest);
    }

    public override void TestShowResult(BattleResult battleResult)
    {
        base.TestShowResult(battleResult);
         
        if (Game.Instance)
            testResultText.text = $"分数：{battleResult.score}\n点击屏幕进入下一关";
        else
            testResultText.text = $"分数：{battleResult.score}\n点击屏幕重新开始";

    }

    private void OnPointerDown(Vector3 position)
    {
        hoppingBattleController.OnPointerDown(position);
    }

    private void OnPointerMove(Vector2 dir)
    {   
        /*var vec = new Vector3(dir.x,0,dir.y);
        var cd = hoppingBattleController.HoppingBattle3DScene.battleCameraParent.curCam.transform.TransformDirection(vec);
        cd.y = 0;*/
        hoppingBattleController.OnPointerMove(dir);
    }
    
    private void OnPointerUp(Vector3 position)
    {
        hoppingBattleController.OnPointerUp(position);
    }

    
    void Update()
    {
       
        
    }
    
}