using UnityEngine;

public abstract class BuffProcessor : MultiStateProcessor
{
    public override void OnEnter<T1,T2>(T1 widget, T2 dataCoreEntity)
    {
        RoleEntity player = widget as RoleEntity;
        BattleBuff buff = dataCoreEntity as BattleBuff;

        OnEnter(player, buff);
    }
    public virtual void OnEnter(RoleEntity player, BattleBuff buff)
    {

    }

    public override void BuffProcess<T1,T2>(T1 widget, T2 dataCoreEntity)
    {
        RoleEntity player = widget as RoleEntity;
        BattleBuff buff = dataCoreEntity as BattleBuff;

        BuffProcess(player, buff);
    }
    public abstract void BuffProcess(RoleEntity player, BattleBuff buff);

    public override void OnExit<T1,T2>(T1 widget, T2 dataCoreEntity)
    {
        RoleEntity player = widget as RoleEntity;
        BattleBuff buff = dataCoreEntity as BattleBuff;

        OnExit(player, buff);
    }
    public virtual void OnExit(RoleEntity player, BattleBuff buff)
    {

    }

}


public class OnDamageProcessor : BuffProcessor
{

    public override void OnEnter(RoleEntity player, BattleBuff buff)
    {
        BattleBuffDamage buffDamage = buff as BattleBuffDamage;

        //player.battle3dScene.ui.AddNumInfo(buffResult.damage, player.transform, Vector3.up * 300);
        
        RoleController rc = buffDamage.receiver.rc;

        Vector3 targetPos = rc.transform.TransformPoint(Vector3.forward);
        ///爆点
        var dir = (targetPos - rc.transform.position).normalized;
        var pref = GameResourceManager.Load<GameObject>(GameResourceManager.hitFX);
        if (pref)
        {
            GameObject fx = GameObject.Instantiate(pref);
            fx.AddComponent<SelfDestroy>();
            fx.transform.position = rc.transform.position + dir * 0.1f + 0.5f * Vector3.up;
        }

        //AudioManager.instance.PlayBattleSound(Audio.hurt,targetPos);
    }

    public override void BuffProcess(RoleEntity player, BattleBuff buff)
    {

    }


}
