﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Runtime.CompilerServices;
using UnityEngine;

public class GameResourceManager  {


    #region folder
    public const string rolesPrefabsPath = "Roles";
    public const string skillIconsPath = "Shared/UI/Sprites/Icons/SkillIcons";
    public const string itemIconsPath = "Shared/UI/Sprites/ItemIcon";
    public const string otherIconsPath = "Shared/UI/Sprites/OtherIcon";
    public const string fontPath = "Font";
    public const string uiSoundPath = "Shared/UI/Sound";
    public const string battleSceneSoundPath = "B_Battle/Battle/SceneSound";
    public const string battleEffectPath = "Scene/Battle/特效";
    public const string rankIconsPath = "Shared/UI/Sprites/RankIcons";
    public const string petIconsPath = "Icons/PetIcons";
    public const string propIconsPath = "Icons/PropIcons";
    public const string goodsIconsPath = "Icons/GoodsIcons";
    public const string skinIconsPath = "Icons/SkinIcons";
    

    #endregion

    #region Battle

    public const string itemDirPath = "B_Battle/Battle/Ball";
    public const string hitFX = "B_Battle/Battle/Effects/tongyongbaodian";
    #endregion

    public const string tipsInfo = "Scene/Common/UI/TipsInfo.prefab";
    public const string scaleTips = "Scene/Common/UI/ScaleTips.prefab";
    
    #region common
    
    public const string sceneLoadingAnimPath = "UI/Prefabs/Common/NormalSceneLoadingAnim.prefab";
    public const string mainSceneUIChangeAnimPath = "UI/Prefabs/Common/MainSceneUIChangeAnim.prefab";
    public const string blackSceneLoadingAnimPath = "UI/Prefabs/Common/BlackSceneLoadingAnimPath.prefab";
    public const string fakeLoadingAnimPath = "UI/Prefabs/Common/FakeSceneLoadingAnim";
    public const string audioSourceTemPath = "Shared/Prefabs/AudioSource.prefab";

    #endregion
    
    #region audio
    public const string homeSceneMusic = "Music/pw_home_01";
    public const string battleSceneMusic = "Music/pw_battle_01";

    #endregion

    public static T Load<T>(string resPath) where T : UnityEngine.Object
    {
        return Load<T>(resPath, false, false);
    }

    public static T Load<T>(string resPath, bool usePool, bool clear) where T : UnityEngine.Object
    {
        T res = null;

        if (usePool)
        {
            //  return EasyObjectPool.instance.GetObjectFromPool(assetPath, Vector3.zero, Quaternion.identity, clear);
        }
        else
        {
            if (resPath.Contains("Assets"))
            {
#if UNITY_EDITOR
                res = UnityEditor.AssetDatabase.LoadAssetAtPath<T>(resPath);
#endif
            }
            else
            {
                string extent = Path.GetExtension(resPath);
                string filePath = resPath;

                if (!string.IsNullOrEmpty(extent))
                    filePath = resPath.Replace(extent, "");

                res = Resources.Load<T>(filePath);
                if (res == null)
                    Debug.LogError("Load failed  filePath: " + filePath);
            }
        }
        return res;
    }

    public static T LoadPrefab<T>(string assetPath) where T : UnityEngine.Object
    {
        if (!assetPath.EndsWith(".prefab"))
        {
            assetPath = assetPath + ".prefab";
        }
        return Load<T>(assetPath, false, false);
    }

    static Sprite LoadSprite(string folderPath, string spirteName)
    {
        // string path = CommonFunctions.PathCombine(folderPath, spirteName);
        string path = Path.Combine(folderPath, spirteName);
        if (path.Contains("."))
            path = Path.GetFileNameWithoutExtension(path);

        path += ".png";
        // Debug.Log("LoadSprite  path:" + path);
        var go = Load<Sprite>(path);
        if (go != null)
        {
            return go;
        }
        else
        {
            Debug.LogError("LoadSprite failed! path:" + path);
            return null;
        }
    }
    public static AudioClip LoadUIAudio(string audioName)
    {
        return LoadAudio(uiSoundPath, audioName);
    }

    public static AudioClip LoadBattleSceneAudio(string audioName)
    {
        return LoadAudio(battleSceneSoundPath, audioName);
    }
    public static AudioClip LoadPetSceneAudio(int petId,string audioName)
    {
        return LoadAudio(rolesPrefabsPath+string.Format("/{0:D2}/Sound/", petId), audioName);
    }
    static AudioClip LoadAudio(string audiosDir, string audioName)
    {
        string path = Path.Combine(audiosDir, audioName);
        return LoadAudio(path);
    }

    public static AudioClip LoadAudio(string path)
    {
        //string path = CommonFunctions.PathCombine(audiosPath, audioName);
        if (path.Contains("."))
            path = Path.Combine( Path.GetDirectoryName(path), Path.GetFileNameWithoutExtension(path));

        path += ".wav";
        var go = Load<AudioClip>(path);

        if (go == null)
        {
            path = path.Replace(".wav", ".wma");
            go = Load<AudioClip>(path);
        }
        if (go == null)
        {
            path = path.Replace(".wma", ".mp3");
            go = Load<AudioClip>(path);
        }
        if (go != null)
        {
            return go;
        }
        else
        {
            Debug.LogError("LoadAudio failed! path:" + path);
            return null;
        }
    }


    #region 角色相关

    public static string GetRolePrefabPath(int roleId)
    {
        string prefabName = string.Format("{0:D2}", roleId);
        string relativePath = prefabName + "/" + prefabName;
        string path = Path.Combine(rolesPrefabsPath, relativePath);
        return path;
    }

    /*public static RoleController LoadRolePrefab(int roleId)
    {
        string path = GetRolePrefabPath(roleId);
        var prefab = LoadRolePrefab(path, false);
        return prefab;
    }

    public static RoleController LoadRolePrefab(string path, bool log)
    {
        if (!path.EndsWith(".prefab")) path += ".prefab";
        var go = Load<RoleController>(path);
        if (go != null)
        {
            return go;
        }
        else
        {
            if (log)
                Debug.LogError("LoadRolePrefab failed! path:" + path);
            return null;
        }
    }*/

    /// <summary>
    /// 角色Icon
    /// </summary>
    /// <param name="spriteName"></param>
    /// <returns></returns>
    public static Sprite LoadRoleIcon(int roleId)
    {
        return LoadSprite(petIconsPath, string.Format("{0:D2}", roleId));
    }

    public static Sprite LoadRoleSkinIcon(int skinId)
    {
        string imgName = string.Format("{0:D2}", skinId);
        return LoadSprite(skinIconsPath, imgName);
    }
    

    public static Sprite LoadSkillIcon(int skillId)
    {
        string spriteName = string.Format("{0:D2}", skillId);
        string path = Path.Combine(skillIconsPath, spriteName);
        return Load<Sprite>(path);
    }

    #endregion

    public static Sprite LoadPropIcon(int propId)
    {
        string path = Path.Combine(propIconsPath,$"img_prop_{propId}");
        return Load<Sprite>(path);
    }

    public static Sprite LoadGoodsIcon(string goodsId)
    {
        string path = Path.Combine(goodsIconsPath, $"img_goods_{goodsId}");
        return Load<Sprite>(path);
    }
    
    public static Sprite LoadOtherIcon(string spriteName)
    {
        string path = Path.Combine(otherIconsPath, spriteName);
        return Load<Sprite>(path);
    }

    public static Sprite LoadRankIcon(int rank)
    {
        string spriteName = string.Format("img_rank_icon{0}", rank);
        string path = Path.Combine(rankIconsPath, spriteName);
        return Load<Sprite>(path);
    }

}
