using System.Collections.Generic;

/// <summary>
/// 用户数据（用于单机保存本地）
/// </summary>
public class LocalUserData
{
    public long id;
    
    public int coin;

    public int diamond;

    public int level;
    public int[] blueprints;
    public int loginDays;
    public int[] acquiredDailyRewared;
    public int[] acquiredMissionReward;
    public int[] levelStars;

    public  void InitTestData()
    {
        id = 0;
        level = 1;
        blueprints = new int[0];
        acquiredDailyRewared =new int[0];
        levelStars = new int[Game.maxLevel];
    }

/*    public static User Data2User(TestUserData data)
    {
        
    }*/

    public static LocalUserData User2Data(GameUser user)
    {
        LocalUserData localUserData = new LocalUserData();
        localUserData.id = user.id;
        localUserData.coin = user.coin;
        localUserData.diamond = user.diamond;
        localUserData.level = user.level;
        if (user.blueprints != null)
        {
            localUserData.blueprints = user.blueprints.ToArray();
        }

        localUserData.loginDays = user.loginDays;
        
        if (user.acquiredDailyReward != null)
        {
            localUserData.acquiredDailyRewared = user.acquiredDailyReward.ToArray();
        }

        if (user.acquiredMissionReward != null)
        {
            localUserData.acquiredMissionReward = user.acquiredMissionReward.ToArray();
        }
        if (user.levelStars != null)
        {
            localUserData.levelStars = user.levelStars.ToArray();
        }
        return localUserData;
    }
}

