

using System;
using System.Collections.Generic;
using System.Linq;
using Newtonsoft.Json.Utilities;
using Unity.Collections.LowLevel.Unsafe;
using UnityEngine;

public class GameUser
{
    private long m_Id;
    public long id => m_Id;

    private string m_Name;
    public string name => m_Name;

    /// <summary>
    /// 金币
    /// </summary>
    private int m_Coin;
    public int coin => m_Coin;

    private int m_Diamond;
    public int diamond => m_Diamond;

    /// <summary>
    /// 等级
    /// </summary>
    private int m_Level;
    public int level => m_Level;

    /// <summary>
    /// 所有蓝图
    /// </summary>
    private List<int> m_Blueprints;
    public List<int> blueprints => m_Blueprints;

    /// <summary>
    /// 已获取的登录奖励
    /// </summary>
    private List<int> m_AcquiredDailyReward;
    public List<int> acquiredDailyReward => m_AcquiredDailyReward;
    
    /// <summary>
    /// 已获取的任务奖励
    /// </summary>
    private List<int> m_AcquiredMissionReward;
    public List<int> acquiredMissionReward => m_AcquiredMissionReward;

    /// <summary>
    /// 登录天数
    /// </summary>
    private int m_LoginDays;
    public int loginDays => m_LoginDays;
    
    /// <summary>
    /// 关卡星星
    /// </summary>
    private List<int> m_LevelStars;
    public List<int> levelStars => m_LevelStars;
    
    public void Init(LocalUserData localUserData)
     {
         m_Id = localUserData.id;

         this.m_Coin = localUserData.coin;
         this.m_Diamond = localUserData.diamond;
         this.m_Level = localUserData.level;

         if (localUserData.blueprints != null)
         {
             this.m_Blueprints = new List<int>(localUserData.blueprints);
         }
         if (localUserData.acquiredDailyRewared != null)
         {
             this.m_AcquiredDailyReward = new List<int>(localUserData.acquiredDailyRewared);
         }
         
         if (localUserData.acquiredMissionReward != null)
         {
             this.m_AcquiredMissionReward = new List<int>(localUserData.acquiredMissionReward);
         }
         
         this.m_LoginDays = localUserData.loginDays;

         int curLoginDay = System.DateTime.Now.Day;
         if (curLoginDay != lastLoginDay)
         {
             m_LoginDays++;
             lastLoginDay = curLoginDay;
             GameDebug.LogError($"登录天数+1:{m_LoginDays}");
             UpdateLocalData();
         }
         if (localUserData.levelStars != null)
         {
             this.m_LevelStars = new List<int>(localUserData.levelStars);
           
             while ( this.m_LevelStars.Count < Game.maxLevel)
             {
                 this.m_LevelStars.Add(0);
             }
         }
         else
         {
             this.m_LevelStars = new List<int>(new int[Game.maxLevel]);
         }
     }

    private const string LastLoginDayKey = "LastLoginDay_Key";

    /// <summary>
    /// 上次登录的日期
    /// </summary>
    static int lastLoginDay
    {
        get { return PlayerPrefs.GetInt(LastLoginDayKey); }
        set{PlayerPrefs.SetInt(LastLoginDayKey,value);}
    }
    
    public static Action<int> onUpdateDiamond;
    
    public void UpdateDiamond(int diamond,bool  updateRemote =  true)
    {
        this.m_Diamond = diamond;
        
        UpdateLocalData();
        
        onUpdateDiamond?.Invoke(diamond);
    }
    
    public static Action<int> onUpdateCoin;

    public void UpdateCoin(int coin,bool  updateRemote =  true)
    {
        GameDebug.Log($"金币由{m_Coin} 更新为：{coin}");
        this.m_Coin = coin;
        
        UpdateLocalData();
        
        onUpdateCoin?.Invoke(coin);
    }

    private const int maxCardNum = 3;

    public static Action<int> onUpdateCard;

    public void UpdateLevel(int level)
    {
        this.m_Level = level;
        
        UpdateLocalData();
    }

    public void UpdateLocalData()
    {
        string str = Newtonsoft.Json.JsonConvert.SerializeObject(GetLocalUserData());
        PlayerPrefs.SetString(Game.LocalUserDataKey,str);
        
        GameDebug.Log($"更新本地数据：{str}");
    }
    
    public LocalUserData GetLocalUserData()
    {
        return LocalUserData.User2Data(this);
    }

    public void ReduceCoin(int num)
    {
        int coin = this.m_Coin - num;
        GameDebug.Log($"coin :{m_Coin} 减去：{num} to:{coin}");
        coin = Mathf.Max(0, coin);
        UpdateCoin(coin);
    }

    public void AddCoin(int num)
    {
        int coin = m_Coin + num;
        coin = Mathf.Max(0, coin);
        UpdateCoin(coin);
    }

    public void ReduceDiamond(int num)
    {
        int diamond = this.m_Diamond - num;
        diamond = Mathf.Max(0, diamond);
        UpdateDiamond(diamond);
    }

    public void AddDiamond(int num)
    {
        int diamond = this.m_Diamond + num;
        diamond = Mathf.Max(0, diamond);
        UpdateDiamond(diamond);
    }

    public void UpdateLevelStar(int level, int star)
    {
        int index = level - 1;
        if (index < m_LevelStars.Count)
        {
            if (this.m_LevelStars[index] < star)
            {
                this.m_LevelStars[index] = star;
            }
        }
        else
        {
            GameDebug.LogError($"m_LevelStars.Count：{m_LevelStars.Count}   level：{level}");
        }
    }


    public int GetStar(int level)
    {
        int index = level - 1;
        if (index < m_LevelStars.Count)
        {
            return this.m_LevelStars[index];
        }
        else
        {
            GameDebug.LogError($"m_LevelStars.Count：{m_LevelStars.Count}   level：{level}");
            return 0;
        }
    }


}


