﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ColliderTrigger : MonoBehaviour
{
    public Action<Collider> onTriggerEnter;
    public Action<Collider> onTriggerExit;
    public Action<Collider> oCollisionEnter;
    public Action<Collider> oCollisionStay;
    public Action<Collider> oCollisionExit;
    // Start is called before the first frame update
    void Start()
    {
        
    }

    private void OnTriggerEnter(Collider other)
    {
        onTriggerEnter?.Invoke(other);
    }

    private void OnTriggerExit(Collider other)
    {
        onTriggerExit?.Invoke(other);
    }

    private void OnCollisionEnter(Collision other)
    {
        oCollisionEnter?.Invoke(other.collider);
    }
    private void OnCollisionStay(Collision other)
    {
        oCollisionStay?.Invoke(other.collider);
    }
    private void OnCollisionExit(Collision other)
    {
        oCollisionExit?.Invoke(other.collider);
    }

    // Update is called once per frame
    void Update()
    {
        
    }
}
