﻿//using Protocols.Base;
using System;
using System.Collections.Generic;
using UnityEngine;

public partial class Battle3DScene
{

    public static string testMapEditDataSavePath(int mapId) => $"Assets/Resources/{mapPrefabDir}/Data/Map{mapId}.bytes";

    public const string mapPrefabDir = "B_Battle/Battle/Maps";

    public static string GetMapPrefabPath(int mapId) => mapPrefabDir + string.Format("/场景{0}.prefab", mapId);

    public static BattleMapData LoadLocalData(int mapId)
    {
        try
        {
            string resPath = testMapEditDataSavePath(mapId).Replace("Assets/Resources/", "");
            resPath = resPath.Replace(".bytes", "");

            var bytes = Resources.Load<TextAsset>(resPath).text;

            BattleMapData mapEditData = Newtonsoft.Json.JsonConvert.DeserializeObject<BattleMapData>(bytes);

            return mapEditData;
        }
        catch (Exception e)
        {
            GameDebug.LogError(e);
            return null;
        }
    }


    void ClearPosSign()
    {
        BattleMapEditorPositionSign[] signs = GetComponentsInChildren<BattleMapEditorPositionSign>();

        for (int i = 0; i < signs.Length; i++)
        {
            Destroy(signs[i]);
        }
    }


    public BattleMapData GetData()
    {
        BattleMapData battleMapData = new BattleMapData();

        battleMapData.mapId = this.m_MapId;
        battleMapData.limitTime = this.gameTime;
        battleMapData.targetScore = this.targetScore;

        /*
         battleMapData.mapEditWidgets = new List<MapEditWidgetData>();
         ViewEntity[] viewEntities = mapEditItemsParent.GetComponentsInChildren<ViewEntity>();
         for (int i = 0; i < viewEntities.Length; i++)
         {
             MapEditWidgetData cur = viewEntities[i].GetMapEditData();
             cur.editId = i;
             battleMapData.mapEditWidgets.Add(cur);
         }
 */

        return battleMapData;
    }


}
