using System;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

/// <summary>
/// 战斗3D场景
/// </summary>
public partial class Battle3DScene : MonoBehaviour
{
    /// <summary>
    /// 地图ID
    /// </summary>
    [SerializeField][HideInInspector]
    int m_MapId;
    public int mapId
    {
        get { return m_MapId; }
        set { m_MapId = value; }
    }
    
    /// <summary>
    /// 时间
    /// </summary>
    [SerializeField][HideInInspector]
    int m_GameTime;
    public int gameTime
    {
        get { return m_GameTime; }
        set { m_GameTime = value; }
    }
    
    /// <summary>
    /// 时间
    /// </summary>
    [SerializeField][HideInInspector]
    int m_TargetScore;
    public int targetScore
    {
        get { return m_TargetScore; }
        set { m_TargetScore = value; }
    }

    BattleController m_BattleController;
    public BattleController battleController => m_BattleController;
    
    /// <summary>
    /// 声音控制器
    /// </summary>
    private AudioManager m_AudioManager;
    public AudioManager audioManager => m_AudioManager;
    
    /// <summary>
    /// 战斗摄像机
    /// </summary>
    [SerializeField]
    private Camera m_Camera;
    public Camera mainCamera => m_Camera;

    [SerializeField]
    private Transform m_LogicItemsParent;
    public Transform logicItemsParent => m_LogicItemsParent;

    public float gameStartCamMoveTime;
    
    protected virtual void Awake()
    {
        m_Camera = GetComponentInChildren<Camera>();
        
        var listener = GetComponentInChildren<AudioListener>();
        if(listener)
            Destroy(listener);
        
        if (m_LogicItemsParent == null)
        {
            m_LogicItemsParent = transform.Find("逻辑物件");
        }
    }

    private void OnEnable()
    {
    }

    public void Init(AudioManager audioManager,BattleController battleController)
    {
        m_AudioManager = audioManager;
        m_BattleController = battleController;
    }
    
    protected virtual void Start()
    {
        float ratio = (float)Screen.width / Screen.height;

        float f = (1080 / 1920f) / ratio ;

        if (f > 1)
        {
            this.m_Camera.fieldOfView = f * 60 * 1.0f ;
        }
    }
    
     /// <summary>
    /// 显示层更新
    /// </summary>
    void Update ()
     {
         if (battleController == null)
             return;
         
    }
}

