﻿
using System.IO;

public static class PathEx
{
    /// <summary>
    /// "/.../path/"    -> "/.../path"
    /// "/.../path////" -> "/.../path"
    /// </summary>
    public static string TrimFolderEnd(string folder)
    {
        if (string.IsNullOrEmpty(folder)) return folder;

        int maxIndex = folder.Length - 1;
        
        for (int i = maxIndex; i > 0; --i)
        {
            if (folder[i] != Path.DirectorySeparatorChar || folder[i] == '/')
            {
                if (i == maxIndex)
                {
                    return folder;
                }

                return folder.Substring(0, i + 1);
            }
        }

        return folder;
    }
    
    #if UNITY_EDITOR
    [UnityEditor.MenuItem("Test/Path/TrimFolderEnd")]
    static void TestTrimFolderEnd()
    {
        GameDebug.Log(PathEx.TrimFolderEnd("/.../path"));
        GameDebug.Log(PathEx.TrimFolderEnd("/.../path/"));
        GameDebug.Log(PathEx.TrimFolderEnd("/.../path//"));
        GameDebug.Log(PathEx.TrimFolderEnd("/.../path///"));

        string testPath = "/Users/zhangke/Documents/DY/CatchMeNow/Client/Assets/Editor/CodeTest/:::yuyuy\\";
        GameDebug.Log(Directory.Exists(testPath));
        GameDebug.Log(PathEx.TrimFolderEnd(testPath));
    }
#endif
}
