﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public interface  IAnalytics
{
    void BattleStart(int level);
    void BattleEnd(int level,bool win,int score);
}

#if Voodoo
public class VoodooAnalytics : IAnalytics
{
    public void BattleStart(int level)
    {
        Debug.Log($"BattleStart ：{level}");
        TinySauce.OnGameStarted(level.ToString());
    }

    public void BattleEnd(int level, bool win, int score)
    {
        Debug.Log($"BattleEnd ：{level}");
        TinySauce.OnGameFinished(level.ToString(),win,score);
    }
}
#endif